package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.BookRecordUpdateLogBiz;
import com.xxfc.platform.vehicle.entity.BookRecordUpdateLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/bookRecord")
public class BookRecordUpdateLogController {

    @Autowired
    BookRecordUpdateLogBiz bookRecordUpdateLogBiz;

    @PostMapping(value = "/update")
    public ObjectRestResponse save(@RequestBody BookRecordUpdateLog bookRecordUpdateLog) {
        return bookRecordUpdateLogBiz.save(bookRecordUpdateLog);
    }

    @GetMapping(value = "/get")
    public ObjectRestResponse<List<BookRecordUpdateLog>> get(Long bookRecordId) {
        return bookRecordUpdateLogBiz.selectByBookRecordId(bookRecordId);
    }

}
