package com.xxfc.platform.summit.service;


import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;

import com.xxfc.platform.summit.util.Sha1;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.alibaba.fastjson.JSONObject;
import java.util.Map.Entry;

@Service
public class WXjsService {


	@Autowired
	JsTicketService jsTicketService;

	@Value("${wx.appid}")
	private String wy_appid;

	/**
	 * 生成js 微信调用配置参数
	 * @param _wxShareUrl:回掉的地址
	 * @return
	 */
	public  JSONObject getShareData(String _wxShareUrl)
	{
		JSONObject data = new JSONObject();
		Map<String, String> _wxMap = new TreeMap<String, String>();
		//noncestr
		String _wxNoncestr = UUID.randomUUID().toString().replace("-", "");
		String _wxTimestamp = (System.currentTimeMillis() / 1000) + "";
		String _wxJsapiTicket = jsTicketService.getTicket(JsTicketService.JsApiType.jsapi).getTicket();
		//参数封装
		_wxMap.put("noncestr", _wxNoncestr);
		_wxMap.put("timestamp", _wxTimestamp );
		_wxMap.put("jsapi_ticket", _wxJsapiTicket);
		_wxMap.put("url", _wxShareUrl);
		data.put("noncestr", _wxNoncestr);
		data.put("timestamp", _wxTimestamp );
		data.put("jsapi_ticket", _wxJsapiTicket);
		data.put("url", _wxShareUrl);
		data.put("appId", wy_appid);
		// 加密获取signature
		StringBuilder _wxBaseString = new StringBuilder();
		for (Entry<String, String> param : _wxMap.entrySet()) {
		    _wxBaseString.append(param.getKey()).append("=").append(param.getValue()).append("&");
		}
		String _wxSignString = _wxBaseString.substring(0, _wxBaseString.length() - 1);
		data.put("sign",   Sha1.getSha1(_wxSignString));
		return data;
	}

	
}
