package com.github.wxiaoqi.security.common.log;

import com.github.wxiaoqi.security.common.log.entity.LogEntity;
import com.github.wxiaoqi.security.common.log.entity.XxLogEntity;
import com.github.wxiaoqi.security.common.msg.BaseResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import org.aspectj.lang.ProceedingJoinPoint;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;

public interface CommonLogService {

    /**
     * 记录日志
     * @param logEntity
     */
    void log(LogEntity logEntity);

    /**
     * 记录日志
     * @param xxLogEntity
     */
    void commonLog(XxLogEntity xxLogEntity);

    /**
     * 初始化日志前半部分
     * @param xxLogEntity
     * @param request
     */
    void initCommonLogPrePart(XxLogEntity xxLogEntity, HttpServletRequest request, ProceedingJoinPoint pjp);

    /**
     * 初始化日志后半部分
     * @param xxLogEntity
     * @param result
     */
    void initCommonLogLastPart(XxLogEntity xxLogEntity, Object result);

    /**
     * 初始化日志后半部分(String)
     * @param xxLogEntity
     * @param result
     */
    void initCommonLogLastPart(XxLogEntity xxLogEntity, String result);


    /**
     * 初始化FeignClient日志前半部分
     * @param xxLogEntity
     * @param targetMethod
     */
    void initFeignClientLogPrePart(XxLogEntity xxLogEntity, Method targetMethod);


    /**
     * 初始化mq消息日志前半部分
     * @param xxLogEntity
     * @param targetMethod
     */

    void initMqLogPrePart(XxLogEntity xxLogEntity, Method targetMethod);

}
