package com.xxfc.platform.universal.controller;



import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.biz.JPushBiz;
import com.xxfc.platform.universal.entity.MessagePush;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 极光推送
 */
@RestController
@RequestMapping("jpush")
@IgnoreUserToken
public class JPushController {

       @Autowired
       JPushBiz jPushBiz;



    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.GET) //匹配的是href中的download请求
    public ObjectRestResponse sendSms(@RequestParam("title") String title) throws Exception {

        return jPushBiz.jpushToAllPlat(title);
    }

    @RequestMapping(value = "/app/unauth/alls", method = RequestMethod.GET) //匹配的是href中的download请求
    public ObjectRestResponse alls() throws Exception {
        return jPushBiz.jpushToAllPlat1();
    }

    @RequestMapping(value = "/stype", method = RequestMethod.GET)
    public ObjectRestResponse stype(@RequestParam(value = "id",defaultValue = "0") Integer id,
                                   @RequestParam(value = "userIds",defaultValue = "") String userIds) throws Exception {
        return jPushBiz.jpushToAlias(id,userIds);
    }

    @RequestMapping(value = "/addMessagePush", method = RequestMethod.POST)
    public ObjectRestResponse addMessagePush(@RequestBody MessagePush messagePush){
        return jPushBiz.updMessagePush(messagePush);
    }

    @RequestMapping(value = "/udpMessagePush", method = RequestMethod.POST)
    public ObjectRestResponse udpMessagePush(@RequestBody MessagePush messagePush){
        return jPushBiz.updMessagePush(messagePush);
    }


    @RequestMapping(value = "/del", method = RequestMethod.POST)
    public ObjectRestResponse delMessagePush(@RequestBody MessagePush messagePush){
        return jPushBiz.delMessagePush(messagePush);
    }
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public ObjectRestResponse getList(@RequestParam(value = "page",defaultValue = "1") Integer page,
                                      @RequestParam(value = "limit",defaultValue = "10") Integer limit,
                                      @RequestParam(value = "title",defaultValue = "") String title,
                                      @RequestParam(value = "type",defaultValue = "0") Integer type){
        return jPushBiz.getList(page,limit,title,type);
    }



}

