package com.xxfc.platform.order.config;

import com.github.wxiaoqi.security.common.config.rabbit.RabbitCommonConfig;
import com.github.wxiaoqi.security.common.config.rabbit.BindDTO;
import org.springframework.context.annotation.Configuration;

import java.util.ArrayList;

import static com.github.wxiaoqi.security.common.config.rabbit.RabbitConstant.*;


/**
 * rabbitmq配置类
 * 包含： 不知道什么orderWater队列
 * @author zhoujw
 * @date 2019/7/15
 */
@Configuration
public class RabbitOrderConfig extends RabbitCommonConfig {

    //退款队列 绑定订单完成
    public static final String ORDER_DEPOSIT_REFUND_QUEUE = "order.deposit.refund.queue";



    public static final String ORDER_DEPOSIT_FINISH_QUEUE = "order.deposit.finish.queue";


    //同步企业信息
    public static final String ORDER_CORPORATION_UPD_QUEUE = "order.corporation:upd.queue";

    //同步门店信息
    public static final String ORDER_COMPANY_UPD_QUEUE = "order.company:upd.queue";

    static {
        myQueue = new ArrayList<BindDTO>(){{
            add(new BindDTO(ORDER_DEPOSIT_REFUND_QUEUE, ORDER_TOPIC, KEY_ORDER_FINLISH));

            add(new BindDTO(ORDER_DEPOSIT_FINISH_QUEUE, ORDER_TOPIC, KEY_ORDER_FINLISH));
            //企业
            add(new BindDTO(ORDER_CORPORATION_UPD_QUEUE, VEHICLE_TOPIC, KEY_CORPORATION_UPD));
            //门店
            add(new BindDTO(ORDER_COMPANY_UPD_QUEUE, VEHICLE_TOPIC, KEY_COMPANY_UPD));
        }};
    }

}

