package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleCataBiz;
import com.xxfc.platform.vehicle.biz.VehiclePlatCataBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.common.VehicleBaseController;
import com.xxfc.platform.vehicle.entity.VehiclePlatCata;
import com.xxfc.platform.vehicle.pojo.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import sun.java2d.pipe.AATextRenderer;

import java.util.Arrays;

@RestController
@RequestMapping("/cata")
@Slf4j
@IgnoreClientToken

public class VehicleCataController extends VehicleBaseController<VehiclePlatCataBiz> {

    @Autowired
    VehicleCataBiz vehicleCataBiz;


    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public RestResponse update(@RequestBody CataVo cataVo) throws Exception {
        return baseBiz.update(cataVo);
    }
    @RequestMapping(value = "/app/all", method = RequestMethod.POST)
    public RestResponse test() throws Exception {
        AppUserDTO userDTO =getUserInfo();

        return RestResponse.data(userDTO);
    }

    @RequestMapping(value = "/app/unauth/all", method = RequestMethod.POST)
    @IgnoreUserToken
    public RestResponse all() throws Exception {
        return RestResponse.data(baseBiz.findTypeTree());
    }

    @RequestMapping(value = "/bind", method = RequestMethod.POST)
    public RestResponse bind(
            @RequestParam(value = "ids",defaultValue = "") String  ids,
            @RequestParam(value = "modelId",defaultValue = "0") Integer  modelId
    ) throws Exception {
        return vehicleCataBiz.updateCataByModel(ids,modelId);
    }




    /**
     * 根据父类id获取子标签
     * @param parentId
     * @return
     */
    @GetMapping(value = "/add/fingCatasByParentId/{parentId}")
    public ObjectRestResponse fingCatasByParentId(@PathVariable Integer parentId ){
        return   baseBiz.fingCatasByParentId(parentId);

    }

    /**
     * 查询一个一级标签及其子标签
     * @param id
     * @return
     */
    @GetMapping(value = "/add/findCascade/{id}")
    public ObjectRestResponse findCascade(@PathVariable Integer id){

        return baseBiz.findCascade(id);

    }


    /**
     * 分页或不分页,获取一级标签及其子标签
     * @param page 当前页
     * @param limit 每页条数
     * @param sort 分类 0-增加车型页面,1-标签管理页面
     * @return
     */
    @GetMapping(value = "/add/fingCatasByParentId/{page}/{limit}/{sort}")
    public ObjectRestResponse getCascades(
             @PathVariable Integer page
            ,@PathVariable Integer limit
            ,@PathVariable Integer sort){

        return   baseBiz.getCascades(page,limit,sort);

    }



    /**
     * 级联添加
     * @param cascade
     * @return
     */
    @PostMapping(value = "/add/addCascade/")
    public ObjectRestResponse addCascade(@RequestBody Cascade<VehiclePlatCata> cascade){

        try {
            return baseBiz.addCascade(cascade);
        } catch (Exception e) {
            e.printStackTrace();
            return ObjectRestResponse.createDefaultFail();
        }

    }


    /**
     * 修改和增加一二级标签
     * @param cas
     * @return
     */
    @PostMapping("/add/updateAndAdd")
    public ObjectRestResponse updateAndAdd(@RequestBody Cascade<VehiclePlatCata> cas){

        return  baseBiz.updateAndAdd(cas);
    }


    /**
     * 修改标签排序
     * @param id
     * @param rank
     * @return
     */
    @PutMapping("/add/updateParentRank/{id}/{rank}")
    public ObjectRestResponse updateParentRank(@PathVariable  Integer id,@PathVariable Integer rank){

        return  baseBiz.updateParentRank(id,rank);
    }


    /**
     * 查询当前车型拥有的标签
     * @param ids
     * @return
     */
    @GetMapping("/add/getCatasByIds/{ids}")
    public ObjectRestResponse getCatasByIds(@PathVariable String ids){
        return  baseBiz.getCatasByIds(ids);
    }

   /* @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    public RestResponse<Vehicle> get(@PathVariable String id) {
        return RestResponse.data(baseBiz.get(id));
    }

    @RequestMapping(value = "", method = RequestMethod.POST)
    public RestResponse add(@RequestBody List<AddOrUpdateVehicleVo> addOrUpdateVehicleVoList) throws Exception {
        return baseBiz.add(addOrUpdateVehicleVoList);
    }

    @RequestMapping(value = "", method = RequestMethod.PUT)
    public RestResponse update(@RequestBody List<AddOrUpdateVehicleVo> addOrUpdateVehicleVoList) throws Exception {
        return baseBiz.update(addOrUpdateVehicleVoList);
    }

    @RequestMapping(value = "", method = RequestMethod.DELETE)
    public RestResponse discard(@RequestBody List<String> idList) throws Exception {
        return baseBiz.discard(idList);
    }

    @RequestMapping(value = "/page", method = RequestMethod.GET)
    public RestResponse<PageDataVO<QueryVehicleVo>> getByPage(@RequestParam String vehiclePageQueryVoJson) throws Exception {
        VehiclePageQueryVo vehiclePageQueryVo = null;
        try {
            vehiclePageQueryVo = JSON.parseObject(vehiclePageQueryVoJson, VehiclePageQueryVo.class);

            UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
            if (userDTO != null) {
                if (userDTO.getDataAll() == 2) {
                    List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                    return RestResponse.data(baseBiz.getByPageNotAllData(vehiclePageQueryVo, companyList));
                }
            }

            return RestResponse.data(baseBiz.getByPage(vehiclePageQueryVo));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }*/



}
