package com.xxfc.platform.universal.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.util.HTTPSUtils;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.vo.OrderPayVo;
import com.xxfc.platform.universal.weixin.api.WXPay;
import com.xxfc.platform.universal.weixin.util.HTTPUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.xxfc.platform.universal.entity.OrderPay;
import com.xxfc.platform.universal.mapper.OrderPayMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;
import java.util.List;

/**
 * 订单支付
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Service
@Slf4j
public class OrderPayBiz extends BaseBiz<OrderPayMapper,OrderPay> {


    public JSONObject preparepay( OrderPayVo orderPayVo) {
        if(null == orderPayVo) {
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        if(orderPayVo.getAmount()==null||orderPayVo.getAmount()==0) {
            log.error("-----金额不为为0-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "金额不为为0");
        }
        if(StringUtils.isBlank(orderPayVo.getOrderNo())) {
            log.error("-----订单不能为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "订单不能为空");
        }
        String trade_no =  OrderUtil.GetOrderNumber("");
        String order_no=orderPayVo.getOrderNo();
        Integer amount=orderPayVo.getAmount();
        log.error("---下单---order_no====="+order_no+"--支付订单号--trade_no===="+trade_no+"--金额---amount===="+amount);
        //报名费回调路径
        String jsParam = WXPay.apppay(1+"",orderPayVo.getBody(),"https://"+ SystemConfig.weixinHost+"/api/universal/pay/app/unauth/notify" ,trade_no,orderPayVo.getBuyerIp(),0);
        log.info("报名费回调路径jsParam:"+jsParam);
        if(!StringUtils.isBlank(jsParam))
        {
            try {
                OrderPay orderPay= new OrderPay();
                BeanUtils.copyProperties(orderPay,orderPayVo);
                orderPay.setTradeNo(trade_no);
                orderPay.setSellerAccount(SystemConfig.APP_PARTNER);
                insertSelective(orderPay);
                log.error("---下单---order_no====="+order_no+"----成功");
            } catch (Exception e) {
                e.printStackTrace();
                log.error("---下单---order_no====="+order_no+"----异常---msg==="+ e.getMessage());
                return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
            }
             JSONObject temp = JSON.parseObject(jsParam);
            return JsonResultUtil.createSuccessResultWithObj(temp);
        }else{
            return JsonResultUtil.createDefaultFail();
        }
    }
    //支付回调
    public void notice(String orderNo,String serialNumber){
        log.error("---支付回调---trade_no====="+orderNo+"----开始处理");
        Example example =new Example(OrderPay.class);
        example.createCriteria().andEqualTo("tradeNo", orderNo).andEqualTo("isDel",0).andEqualTo("status",0);
        List<OrderPay> list=mapper.selectByExample(example);
        if(list.size()==0){
            log.error("---支付回调---trade_no====="+orderNo+"----订单不存在或已处理");
             return;
        }
        example.clear();
        example.createCriteria().andEqualTo("tradeNo",orderNo);
        OrderPay orderPay=new OrderPay();
        orderPay.setFinishTime(System.currentTimeMillis());
        orderPay.setStatus(1);
        orderPay.setSerialNumber(serialNumber);
        int num=mapper.updateByExampleSelective(orderPay,example);
        log.error("---支付回调处理---num====="+num+"----orderNo======="+orderNo);
        if(num>0){
            OrderPay pay= list.get(0);
            if(StringUtils.isNotBlank(pay.getNotifyUrl())){
                String url=pay.getNotifyUrl();
                url+="&tradeNo="+orderNo;
                log.error("---支付回调处理---orderNo======="+orderNo+"----notifyUrl===="+url);
                String result="";
                if(url.contains("https")||url.contains("HTTPS")){
                     result= HTTPSUtils.httpRequest(url, "GET",null);
                }else{
                    result= HTTPUtils.doGet(url);
                }
                log.error("---支付回调处理---orderNo======="+orderNo+"---result==="+result);
            }
        }
    }

    public static void main(String[] args) {
        String url="https://xxtest.upyuns.com/api/order/baseOrder/app/unauth/notifyUrl?orderNo=20190603141137010007&tradeNo=20190603141137000002";
        String result="";
        if(url.contains("https")||url.contains("HTTPS")){
            result= HTTPSUtils.httpRequest(url, "GET",null);
        }else{
            result= HTTPUtils.doGet(url);
        }
        System.out.println(result);
    }
}