package com.github.wxiaoqi.security.admin.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


/**
 * 用户会员表
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 19:38:56
 */
@Data
@Table(name = "base_user_member")
public class BaseUserMember implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  会员编号
     */
    @Column(name = "member_no")
	@ApiModelProperty(value = "会员编号")
    private String memberNo;
	
	    /**
     *  会员等级
     */
    @Column(name = "member_level")
	@ApiModelProperty(value = "会员等级")
    private Integer memberLevel;
	
	    /**
     *  卡内余额
     */
    @Column(name = "card_leave")
	@ApiModelProperty(value = "卡内余额")
    private Integer cardLeave;
	
	    /**
     *  0:未支付 1：绑定 2:解绑
     */
    @Column(name = "is_bind")
	@ApiModelProperty(value = "0:未支付 1：绑定 2:解绑")
    private Integer isBind;
	
	    /**
     *  赠送总天数
     */
    @Column(name = "total_number")
	@ApiModelProperty(value = "赠送总天数")
    private Integer totalNumber;
	
	    /**
     *  剩余天数
     */
    @Column(name = "s_number")
	@ApiModelProperty(value = "剩余天数")
    private Integer sNumber;
	
	    /**
     *  有效期;0代表永久
     */
    @Column(name = "valid_time")
	@ApiModelProperty(value = "有效期;0代表永久")
    private Long validTime;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  是否删除；0-正常；1-删除
     */
    @Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
    private Integer isDel;
	

}
