package com.xxfc.platform.vehicle.pojo.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;


/**
 * 用车调度预约记录
 * 
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-25 10:13:57
 */
@Data
public class VehiclDispatchRecordVo {


	@ApiModelProperty("主键id")
    private Integer id;


    @ApiModelProperty(value = "提车地点（公司）")
    private Integer liftCompany;


    @ApiModelProperty(value = "提车地点（公司）名称")
    private String liftCompanyName;


    @ApiModelProperty(value = "提车分公司联系人")
    private String liftCompanyLeader;

    @ApiModelProperty(value = "提车分公司联系人电话")
    private String liftCompanyLeaderTel;

    @ApiModelProperty(value = "实际开始日期(提车时间)")
    private Date actualStartDate;


    @ApiModelProperty(value = "还车地点（公司）")
    private Integer retCompany;


    @ApiModelProperty(value = "还车地点（公司）名称")
    private String retCompanyName;


    @ApiModelProperty(value = "还车分公司联系人")
    private String retCompanyLeader;

    @ApiModelProperty(value = "还车分公司联系人电话")
    private String retCompanyLeaderTel;

    @ApiModelProperty(value = "实际结束日期(还车时间)")
    private Date actualEndDate;




   
	

}
