package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.BranchCompanyBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.pojo.CompanySearchDTO;
import com.xxfc.platform.vehicle.pojo.CompanySearchVO;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("admin/branchCompany")
@Slf4j
@IgnoreClientToken
@IgnoreUserToken
@Api(value="公司controller",tags={"公司操作接口"})
public class AdminBranchCompanyController extends BaseController<BranchCompanyBiz,BranchCompany>  implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @RequestMapping(value ="/search",method = RequestMethod.GET)
    public RestResponse<PageDataVO<CompanySearchVO>> search(@Validated CompanySearchDTO vo) {
        setPowerData(vo);
        return RestResponse.data(baseBiz.search(vo));
    }


    @RequestMapping(value ="/details",method = RequestMethod.GET)
    public RestResponse  details(@Validated CompanySearchDTO vo) {
        List<CompanySearchVO> list = baseBiz.getList(vo);
        CompanySearchVO companySearchVO=new CompanySearchVO();
        if (list.size() > 0){
            companySearchVO=list.get(0);
        }
        return RestResponse.data(companySearchVO);
    }



}
