package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.rpc.OrderListBiz;
import com.xxfc.platform.order.pojo.dto.OrderDTO;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/count")
public class OrderListController {

    @Autowired
    OrderListBiz orderListBiz;

    @Autowired
    private BaseOrderBiz baseOrderBiz;

    @GetMapping("/list")
    public ObjectRestResponse<List<OrderPageVO>> getOrderList(@RequestParam("dateTime")Long dateTime, @RequestParam("type")Integer type, @RequestParam("status")Integer status) {
        return orderListBiz.getOrderList(dateTime, type, status);
    }

    @GetMapping(value = "/basebase/findByOrderIds")
    @IgnoreClientToken
    @IgnoreUserToken
    public ObjectRestResponse<List<OrderDTO>> findOrdersByorderId(@RequestParam(value = "orderIds") List<Integer> orderIds){
        return  ObjectRestResponse.succ(baseOrderBiz.selectBaeOrderByOrderIds(orderIds));
    }

    @PostMapping(value = "/basebase/findOrdersByorderIdV2")
    @IgnoreClientToken
    @IgnoreUserToken
    public ObjectRestResponse<List<OrderDTO>> findOrdersByorderIdV2(@RequestBody  List<Integer> orderIds){
        return  ObjectRestResponse.succ(baseOrderBiz.selectBaeOrderByOrderIds(orderIds));
    }
}
