package com.xxfc.platform.activity.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 活动的参与者关系表
 * 
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-17 19:51:17
 */
@Data
@Table(name = "activity_popularize_relation")
public class ActivityPopularizeRelation implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键")
    private Integer id;
	
	    /**
     *  创建时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "创建时间", hidden = true )
    private Long crtTime;
	
	    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;
	
	    /**
     *  主用户
     */
    @Column(name = "major_user_id")
	@ApiModelProperty(value = "主用户")
    private Integer majorUserId;
	
	    /**
     *  次要用户
     */
    @Column(name = "minor_user_id")
	@ApiModelProperty(value = "次要用户")
    private Integer minorUserId;
	
	    /**
     *  活动id
     */
    @Column(name = "popularize_id")
	@ApiModelProperty(value = "活动id")
    private Integer popularizeId;

    @Column(name = "num")
	@ApiModelProperty(value = "第几个用户")
	private Integer num;

    @Column(name = "amount")
	@ApiModelProperty(value = "获得奖励金额")
	private BigDecimal amount;
}
