package com.github.wxiaoqi.security.admin.feign.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 用户详情信息表
 */
@Data
public class AppUserDTO {

	public static final Integer CHANNEL_APP = 1;
	public static final Integer CHANNEL_SMALL = 2;

	public static final Integer source_APP = 1;
	public static final Integer source_SMALL = 2;

	private Integer id;
	private Integer userid;
	private Integer isMember;
	private String username;
	private String wxNickname;
	private String qqNickname;
	private String nickname;
	private String aliPayNickName;
	private String realname;
	private String headimgurl;
	private String email;
	private Integer sex;
	private String birthday;
	private String personSign;
	private String remark;
	//渠道来源；1-app；2-小程序
	private Integer channel;
	/**
	 * 省份编号
	 */
	private Integer provinceCode;

	/**
	 * 市编号
	 */
	private Integer cityCode;

	/**
	 * 创建ip
	 */
	private  String crtHost;
	/**
	 * 更新ip
	 */
	private  String updHost;


	@ApiModelProperty(value = "用户职位")
	private  Integer positionId;

	@ApiModelProperty(value = "用户职位名称")
	private  String positionName;

	@ApiModelProperty(value = "用户来源:0-自来,1-用户邀请")
	private  Integer source;


	@ApiModelProperty(value = "邀请码")
	private  String code;

	@ApiModelProperty(value = "邀请人id:")
	private  Integer inviterAccount;
	@ApiModelProperty(value = "1-新人用户；2-未激活；3-激活:")
	private  Integer state;
	private Integer imUserid;
	private String wxOpenid;
	private String unionid;
	private String openid;
	private Integer status;
	private String idNumber;
	private Integer certificationStatus;
	private Integer rentFreeDays;
	private Integer totalNumber;
	private Integer payCount;
	private Integer buyCount;
	private Integer lockDays;
	private Integer discount;
	private Integer memberLevel = 0;
	private String memberName;
	//图标
	private String icon;
	private String bigIcon;
	private String itemImg;
	private Integer memberNo;
	private Long cardLeave;
	private Boolean isBindWx;
	private Boolean isBindAliPay;
	private Boolean isBindQQ;
	//用户上线
	private Integer  parentId;

}
