package com.xxfc.platform.summit.model;

import java.io.Serializable;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;


/**
 * JsTicket返回封装
 */
public class JsTicket implements Serializable {

	private static final long serialVersionUID = 6600179487477942329L;

	private String ticket; // 正确获取到 ticket 时有值
	private Integer expires_in; // 正确获取到 access_token 时有值
	private Long expiredTime; // 正确获取到 ticket 时有值，存放过期时间

	public JsTicket()
	{
		
	}

	public JsTicket(String jsonStr) {


		try {
			JSONObject temp = JSON.parseObject(jsonStr);
			ticket = temp.getString("ticket");
			expires_in = temp.getInteger("expires_in");


			if (expires_in != null)
				expiredTime = System.currentTimeMillis() + ((expires_in - 5) * 1000);

		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	
	private Integer getInt(Map<String, Object> temp, String key) {
		Number number = (Number) temp.get(key);
		return number == null ? null : number.intValue();
	}
	

	public boolean isAvailable() {
		if (expiredTime == null)
			return false;
	
		if (expiredTime < System.currentTimeMillis())
			return false;
		return ticket != null;
	}

	public String getTicket() {
		return ticket;
	}

	public Integer getExpiresIn() {
		return expires_in;
	}


	public Integer getExpires_in() {
		return expires_in;
	}


	public void setExpires_in(Integer expires_in) {
		this.expires_in = expires_in;
	}


	public Long getExpiredTime() {
		return expiredTime;
	}


	public void setExpiredTime(Long expiredTime) {
		this.expiredTime = expiredTime;
	}


	public void setTicket(String ticket) {
		this.ticket = ticket;
	}


}
