package com.xxfc.platform.user.behavior.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;


/**
 * 用户行为记录表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-08-12 14:03:55
 */
@Data
@Table(name = "customer_behavior_notes")
public class CustomerBehaviorNotes implements Serializable {
    private static final long serialVersionUID = 1L;


    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("主键id")
    private Integer id;


    @Column(name = "customer_id")
    @ApiModelProperty(value = "用户id")
    private String customerId;

    /**
     *  访问者身份 {@link com.xxfc.platform.user.behavior.common.IdentityEnum}
     */
    @Column(name = "customer_type")
    @ApiModelProperty(value = "1-游客；2-用户")
    private Integer customerType;

    /**
     * 行为类型 {@link com.xxfc.platform.user.behavior.common.BehaviorEnum}
     */
    @Column(name = "type")
    @ApiModelProperty(value = "行为类型")
    private Integer type;


    @Column(name = "type_id")
    @ApiModelProperty(value = "类型id")
    private Integer typeId;


    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Long crtTime;


    @Column(name = "request_id")
    @ApiModelProperty(value = "请求id")
    private String requestId;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomerBehaviorNotes that = (CustomerBehaviorNotes) o;
        return Objects.equals(customerId, that.customerId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(customerId);
    }
}
