package com.xxfc.platform.universal.weixin.constant;

import lombok.AllArgsConstructor;

/**
 * @author libin
 * @version 1.0
 * @description  以下错误 如需继续打款，要使用原来的商户订单号
 * @data 2019/10/12 9:11
 */
@AllArgsConstructor
public enum WxNeedPayErrorEnum {
    NOTENOUGH("余额不足","付款帐号余额不足或资金未到账"),
    SYSTEMERROR("系统繁忙，请稍后再试","微信内部接口调用发生错误"),
    NAME_MISMATCH("姓名校验出错","付款人身份校验不通过"),
    SIGN_ERROR("签名错误","校验签名错误"),
    FREQ_LIMIT("超过频率限制，请稍后再试","接口请求频率超时接口限制"),
    MONEY_LIMIT("已经达到今日付款总额上限/已达到付款给此用户额度上限","请关注接口的付款限额条件"),
    CA_ERROR("商户API证书校验出错","请求没带商户API证书或者带上了错误的商户API证书"),
    V2_ACCOUNT_SIMPLE_BAN("无法给非实名用户付款","用户微信支付账户未知名，无法付款"),
    PARAM_IS_NOT_UTF8("请求参数中包含非utf8编码字符","接口规范要求所有请求参数都必须为utf8编码"),
    SENDNUM_LIMIT("该用户今日付款次数超过限制","该用户今日付款次数超过限制");

    private  String desc;
    private String reason;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }
}
