package com.xxfc.platform.universal.feign;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.entity.OrderRefund;
import com.xxfc.platform.universal.vo.OrderPayVo;
import com.xxfc.platform.universal.vo.OrderRefundVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;


/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-21 8:11
 */
@FeignClient(value = "xx-universal")
public interface ThirdFeign {
    @RequestMapping(value = "/sms/app/unauth/send", method = RequestMethod.GET)
    public JSONObject send(@RequestParam(value = "phone") String phone);
    @RequestMapping(value = "/file/app/unauth/uploadFiles", method = RequestMethod.POST)
    public JSONObject uploadFiles(@RequestParam("files") MultipartFile[] files);
    @RequestMapping(value = "/pay/app/wx", method = RequestMethod.POST)
    public JSONObject wx(@RequestBody OrderPayVo orderPayVo);
    @RequestMapping(value = "/refund/app/wx", method = RequestMethod.POST)
    public ObjectRestResponse<String> refund(@RequestBody OrderRefundVo orderRefundVo);

}
