package com.xxfc.platform.order.rest;


import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.biz.OrderTourVerificationBiz;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("tour")
@IgnoreClientToken
@Api(value="旅游订单核销",tags={"旅游订单核销"})
public class OrderTourVerificationController extends CommonBaseController {

    @Autowired
    OrderTourVerificationBiz verificationBiz;

    @Autowired
    protected UserAuthConfig userAuthConfig;

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    UserFeign userFeign;

    public UserDTO getUserInfo(){ return   userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();}

    @RequestMapping(value = "/verification/orderlist",method = RequestMethod.GET)
    @ApiOperation(value = "旅游核销订单列表")
    public ObjectRestResponse orderlist(
           @RequestParam(value = "page",defaultValue = "1") Integer page,
           @RequestParam(value = "limit",defaultValue = "10") Integer limit,
           @RequestParam(value = "verificationId",defaultValue = "0") Integer verificationId
    ){
        return ObjectRestResponse.succ(verificationBiz.getVerificationList(page,limit,verificationId));
    }
    @RequestMapping(value = "/verification/check",method = RequestMethod.GET)
    @ApiOperation(value = "旅游核销")
    public ObjectRestResponse<BaseOrder> check(
            @RequestParam(value = "no",defaultValue = "") String no
    ){
        UserDTO userDTO=getUserInfo();
        if(userDTO==null){
            return ObjectRestResponse.createDefaultFail();
        }
        List<BranchCompany> list=new ArrayList<>();
        if(userDTO.getDataAll()==2){
            list=vehicleFeign.companyAll(userDTO.getDataAll(),userDTO.getDataCompany(),userDTO.getDataZone());
        }

        return verificationBiz.VerificationByOrder(no,list,userDTO);
    }

    @RequestMapping(value = "/verification/finish",method = RequestMethod.GET)
    @ApiOperation(value = "确定发车")
    public ObjectRestResponse<BaseOrder> finishOrder(
            @RequestParam(value = "verificationId",defaultValue = "0") Integer verificationId
    ){
        return verificationBiz.finishByOrder(verificationId);
    }

    @RequestMapping(value = "/verification/list",method = RequestMethod.POST)
    @ApiOperation(value = "旅游核销订单列表")
    public ObjectRestResponse list(@RequestBody TourGoodOrderFindVo tourGoodOrderFindVo) {
        return verificationBiz.getVerifications(tourGoodOrderFindVo);
    }







}