package com.xxfc.platform.order.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Data
public class AddTourDTO {
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    //开始时间
    @ApiModelProperty(value = "活动开始时间")
    private Long startTime;

    //结束时间
    @ApiModelProperty(value = "活动结束时间")
    private Long endTime;

    //取车地点
    @ApiModelProperty(value = "出发地点")
    private String startAddr;

    //还车地点
    @ApiModelProperty(value = "结束地点")
    private String endAddr;

    //自己乘客ids
    @ApiModelProperty(value = "自己乘客ids")
    private String tourUserIds;

    //出发公司Id
    @ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;

    //商品id
    @ApiModelProperty(value = "商品id")
    private Integer goodId;

    //商品规格ids
    @ApiModelProperty(value = "商品规格ids")
    private String speIds;

    //具体商品（商品项）id
    @ApiModelProperty(value = "具体商品（商品项）id")
    private String spePriceId;

    //联系人
    @ApiModelProperty(value = "联系人")
    private String contactMan;

    //联系电话
    @ApiModelProperty(value = "联系电话")
    private String contactPhone;

    //联系邮箱
    @ApiModelProperty(value = "联系邮箱")
    private String contactEmail;

    //站点id
    @ApiModelProperty(value = "站点id")
    private Integer siteId;

    @Column(name = "has_insure")
    @ApiModelProperty(value = "是否保险标记 1--要保险；0--不需要")
    Integer hasInsure;
}
