package com.xxfc.platform.app.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.biz.AppVersionBiz;
import com.xxfc.platform.app.entity.AppVersion;
import com.xxfc.platform.app.entity.Cofig;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

@RestController
@RequestMapping("version")
@IgnoreClientToken
public class AppVersionController extends BaseController<AppVersionBiz,AppVersion> {


    @ApiModelProperty("app自动更新")
    @RequestMapping(value ="/app/unauth/info",method = RequestMethod.GET)
    @IgnoreUserToken
    public ObjectRestResponse info(
            @RequestParam(value = "type",defaultValue = "0") Integer type,
            @RequestParam(value = "version",defaultValue = "") String version
    ){
        return baseBiz.getVersion(version,type);
    }

}