package com.xxfc.platform.app;

import com.ace.cache.EnableAceCache;
import com.github.wxiaoqi.security.api.vo.config.HeaderConfig;
import com.github.wxiaoqi.security.auth.client.EnableAceAuthClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootApplication(scanBasePackages = {
        "com.xxfc.platform",
        "com.github.wxiaoqi.*"
})
@EnableDiscoveryClient
@EnableScheduling
@EnableAceAuthClient
@EnableFeignClients(value = {"com.github.wxiaoqi.security", "com.xxfc.platform"},defaultConfiguration = HeaderConfig.class)
@EnableAceCache
@tk.mybatis.spring.annotation.MapperScan(basePackages = "com.xxfc.platform.app.mapper")
public class AppApplication {

    public static void main(String[] args) {
        SpringApplication.run(AppApplication.class, args);
    }


}
