package com.xxfc.platform.universal.entity.vo;

import com.xxfc.platform.universal.entity.OrderData;
import lombok.Data;


import java.util.List;

/**
 * @Auther: Administrator
 * @Date: 2020/1/3 14:43
 * @Description:
 */
@Data
public class InvoiceVo {

    /**
     * 发票分类：01 专票,02 货物运输业增值税专用发票,03 机动车销售统一发票，
     * 04 增值税普通发票，10 增值税普通发票（电子），11 增值税普通发票（卷票），14 增值税普通发票（卷票）
     */
    private Integer invoiceCategory = 10;

    /**
     * 订单id :多个以逗号隔开
     */
    private String orderId;

    /**
     * 发票订单表id
     */
    private Integer orderInvoiceId;

    /**
     * 备注
     */
    private String remark;

    /**
     * 购买方名称
     */
    private String purchaserName;
    /**
     * 购买方纳税人识别号
     */
    private String purchaserTaxCode;
    /**
     * 购方邮箱
     */
    private String purchaserEmail;
    /**
     * 购买方地址电话
     */
    private String purchaserAddressPhone;
    /**
     * 购买方银行账号
     */
    private String purchaserAccountBank;

    /**
     * 开票内容
     */
    private String content;

    /**
     * 购方手机
     */
    private String purchaserPhone="0";

    /**
     * 用户id
     */
    private Integer userId;
    private String createBy;
    private List<OrderData> orders;


}
