package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.biz.VehicleWarningMsgBiz;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.entity.VehicleWarningMsg;
import com.xxfc.platform.vehicle.pojo.AddVehicleWarningMsgVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/vehicleWarningMsg")
@Slf4j
public class VehicleWarningMsgController{

    @Autowired
    VehicleWarningMsgBiz vehicleWarningMsgBiz;

    private static VehicleWarningMsgController vehicleWarningMsgController;
    @PostConstruct //通过@PostConstruct实现初始化bean之前进行的操作
    public void init() {
        vehicleWarningMsgController = this;
        vehicleWarningMsgController.vehicleWarningMsgBiz = this.vehicleWarningMsgBiz;
        // 初使化时将已静态化的testService实例化
    }
    @RequestMapping(value ="{id}",method = RequestMethod.GET)
    private RestResponse<VehicleWarningMsg> get(@PathVariable Integer id) throws Exception{
        return RestResponse.codeAndData(RestResponse.SUC_CODE,vehicleWarningMsgController.vehicleWarningMsgBiz.selectById(id));
    }


    @RequestMapping(value ="page",method = RequestMethod.GET)
    @IgnoreUserToken
    private RestResponse<PageDataVO<VehicleWarningMsg>> getByPage(@RequestParam String queryVehicleWarningMsgVoJson) throws Exception{
        return vehicleWarningMsgController.vehicleWarningMsgBiz.getByPage(queryVehicleWarningMsgVoJson);
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    private RestResponse<Integer> add(@RequestBody AddVehicleWarningMsgVo addVehicleWarningMsgVo) throws Exception{
        new RestResponse<Map>().setData(new HashMap<String, Object>());
        return vehicleWarningMsgBiz.add(addVehicleWarningMsgVo);
    }

    @RequestMapping(value ="deal/{id}",method = RequestMethod.PUT)
    private RestResponse deal(@PathVariable Integer id) throws Exception{
        return vehicleWarningMsgBiz.deal(id);
    }
}
