package com.xxfc.platform.activity.biz;

import org.springframework.stereotype.Service;

import com.xxfc.platform.activity.entity.ActivityList;
import com.xxfc.platform.activity.mapper.ActivityListMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

/**
 * 活动（活动列表）
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Service
public class ActivityListBiz extends BaseBiz<ActivityListMapper,ActivityList> {
    public List<ActivityList> activities () throws InvocationTargetException, IllegalAccessException {
        long currentTime = System.currentTimeMillis();
        Example exa=Example.builder(ActivityList.class).where(WeekendSqls.<ActivityList>custom()
                .andGreaterThanOrEqualTo(ActivityList::getEndTime,currentTime)
                .andLessThanOrEqualTo(ActivityList::getStartTime,currentTime)
                .andEqualTo(ActivityList::getStatus,1)
        ).orderByAsc("sort").build();
        List<ActivityList> activityLists = selectByExample(exa);

        return activityLists;
    }
}