package com.xxfc.platform.activity.user;

import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Slf4j
@Component
public class UserInfoBiz {

    @Autowired
    UserFeign userFeign;

    public AppUserDTO getUserInfo() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        if(request.getHeader("Authorization") !=null) {
            return userFeign.userDetailByToken(request.getHeader("Authorization")).getData();
        } else if(request.getHeader("access_token") != null) {
            return userFeign.userDetailByToken(request.getHeader("access_token")).getData();
        }
        return null;
    }
}
