package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.PersonalConsumptionDTO;
import com.github.wxiaoqi.security.admin.dto.WalletCathFindDTO;
import com.github.wxiaoqi.security.admin.dto.WalletCathListDTO;
import com.github.wxiaoqi.security.admin.entity.MyWalletCath;
import com.github.wxiaoqi.security.admin.mapper.MyWalletCathMapper;
import com.github.wxiaoqi.security.admin.vo.WalletCathAdminVo;
import com.github.wxiaoqi.security.admin.vo.WalletCathDetailVo;
import com.github.wxiaoqi.security.admin.vo.WalletCathPageVo;
import com.github.wxiaoqi.security.admin.vo.WalletCathVo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import tk.mybatis.mapper.entity.Example;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/12 10:21
 */
@Transactional
@Service
public class MyWalletCathBiz extends BaseBiz<MyWalletCathMapper, MyWalletCath> {

    public WalletCathPageVo findWatchCatchByWithdrawalState(Integer userId, Integer state, Integer pageNo, Integer pageSize) {

        WalletCathPageVo walletCathPageVo = new WalletCathPageVo();

        Example example = new Example(MyWalletCath.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("stauts", state);
        criteria.andEqualTo("userId", userId);
        example.setOrderByClause("crt_time DESC");
        PageDataVO<MyWalletCath> walletCathPage = PageDataVO.pageInfo(pageNo, pageSize, () -> mapper.selectByExample(example));

        List<MyWalletCath> walletCaths = walletCathPage.getData();
        if (CollectionUtils.isEmpty(walletCaths)) {
            walletCathPageVo.setPageNum(pageNo);
            walletCathPageVo.setPageSize(pageSize);
            walletCathPageVo.setTotalCount(0);
            walletCathPageVo.setTotalPage(0);
            walletCathPageVo.setWalletCaths(Collections.EMPTY_LIST);
            return walletCathPageVo;
        }

        WalletCathVo walletCathVo = null;
        BigDecimal totalWithdraw = new BigDecimal(0);
        List<WalletCathVo> walletCatchPageVos = new ArrayList<>();
        for (MyWalletCath walletCath : walletCaths) {
            walletCathVo = new WalletCathVo();
            BeanUtils.copyProperties(walletCath, walletCathVo);
            totalWithdraw = totalWithdraw.add(walletCathVo.getAmount());
            walletCatchPageVos.add(walletCathVo);
        }
        walletCathPageVo.setPageNum(walletCathPage.getPageNum());
        walletCathPageVo.setPageSize(walletCathPage.getPageSize());
        walletCathPageVo.setTotalCount(walletCathPage.getTotalCount().intValue());
        walletCathPageVo.setTotalPage(walletCathPage.getTotalPage());
        walletCathPageVo.setTotalWithdraw(totalWithdraw);
        walletCathPageVo.setWalletCaths(walletCatchPageVos);
        return walletCathPageVo;
    }

    public WalletCathDetailVo getWalletCathDetailById(Long id) {
        WalletCathDetailVo walletCathDetailVo = new WalletCathDetailVo();
        MyWalletCath myWalletCath = new MyWalletCath();
        myWalletCath.setId(id);
        MyWalletCath walletCath = mapper.selectByPrimaryKey(myWalletCath);
        Optional.ofNullable(walletCath).ifPresent(wc -> {
            BeanUtils.copyProperties(wc, walletCathDetailVo);
        });
        return walletCathDetailVo;
    }


    public PageDataVO<WalletCathAdminVo> listWalletCathWithPage(WalletCathFindDTO walletCathFindDTO) {

         PageDataVO<WalletCathAdminVo>  walletCathAdminVoPage = new PageDataVO<>();

        PageDataVO<WalletCathListDTO> walletCathListDTOPage = PageDataVO.pageInfo(walletCathFindDTO.getPage(),
                                                                                       walletCathFindDTO.getLimit(),
                                                                            () -> mapper.selectByUserNameOrPhoneOrWithDrawSate(walletCathFindDTO.getUsername(), walletCathFindDTO.getPhone(), walletCathFindDTO.getState()));

        List<WalletCathListDTO> walletCathListDTOList = walletCathListDTOPage.getData();
        if (CollectionUtils.isEmpty(walletCathListDTOList)){
            return walletCathAdminVoPage;
        }
         List<WalletCathAdminVo> walletCathAdminVos  = new ArrayList<>();
        WalletCathAdminVo walletCathAdminVo ;
        for (WalletCathListDTO walletCathListDTO : walletCathListDTOList) {
            walletCathAdminVo = new WalletCathAdminVo();
            BeanUtils.copyProperties(walletCathListDTO,walletCathAdminVo);
            walletCathAdminVo.setUsername(StringUtils.isEmpty(walletCathListDTO.getRealname())?walletCathListDTO.getNickname():walletCathListDTO.getRealname());
            walletCathAdminVo.setPhone(walletCathListDTO.getUsername());
            walletCathAdminVos.add(walletCathAdminVo);
        }
        walletCathAdminVos.sort(Comparator.comparing(WalletCathAdminVo::getCrtTime).reversed());
        walletCathAdminVoPage.setTotalPage(walletCathListDTOPage.getTotalPage());
        walletCathAdminVoPage.setTotalCount(walletCathListDTOPage.getTotalCount());
        walletCathAdminVoPage.setPageNum(walletCathFindDTO.getPage());
        walletCathAdminVoPage.setPageSize(walletCathFindDTO.getLimit());
        walletCathAdminVoPage.setData(walletCathAdminVos);

        return walletCathAdminVoPage;
    }

    public Map<Integer, BigDecimal> findUserIdAndWithdrawalingMapByUserIds(List<Integer> userIds) {
        List<PersonalConsumptionDTO> personalConsumptions = mapper.findUserWithDrawingByUserIds(userIds);
        Map<Integer, BigDecimal> userIdAndPersonalConsumptionMap = personalConsumptions.stream().collect(Collectors.toMap(PersonalConsumptionDTO::getUserId, PersonalConsumptionDTO::getTotalConsumption));
        return userIdAndPersonalConsumptionMap;
    }
}
