package com.xxfc.platform.vehicle.rest;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleModelCalendarPriceBiz;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelCalendarPriceDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:35
 */
@RestController
@RequestMapping("/vehicle_model/calendar_price/app/unauth")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "车型日历价格")
public class VehicleModelCalendarPriceController {

    private final VehicleModelCalendarPriceBiz vehicleModelCalendarPriceBiz;


    @ApiOperation("返回车型日历价格")
    @GetMapping("/list/{vehicleModelId}")
    @IgnoreUserToken
    @SneakyThrows
    public ObjectRestResponse<VehicleModelCalendarPriceDTO> listVehicleModelCalendarPriceByDateAndVehicleModelId(@RequestParam(value = "start", required = false) String start,
                                                                                                                 @RequestParam(value = "end", required = false) String end,
                                                                                                                 @PathVariable(value = "vehicleModelId") Integer vehicleModelId,
                                                                                                                 AppUserDTO appUserDTO) {
        if (StringUtils.isEmpty(start) || StringUtils.isEmpty(end)) {
            throw new BaseException("缺少开始时间或结束时间");
        }
        Date startDate = Date.from(LocalDate.parse(start).atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date endDate = Date.from(LocalDate.parse(end).atStartOfDay(ZoneId.systemDefault()).toInstant());
        List<VehicleModelCalendarPriceDTO> vehicleModelCalendarPriceVos = vehicleModelCalendarPriceBiz.listVehicleModelCalendarPriceByDateAndVehicleModelIdAndUserId(startDate, endDate, vehicleModelId, appUserDTO.getUserid());
        return ObjectRestResponse.succ(vehicleModelCalendarPriceVos);
    }

    @GetMapping(value = "/price", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> findVehicleModelCalendarPriceByDate(@RequestParam(value = "startDate") Long startDate,
                                                                                                      @RequestParam(value = "endDate") Long endDate,
                                                                                                      @RequestParam(value = "vehicleModelId") Integer vehicleModelId,
                                                                                                      @RequestParam(value = "userId") Integer userId) {

        Date startDateDay = DateUtil.beginOfDay(DateUtil.date(startDate));
        //Date.from(startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date endDateDay = DateUtil.beginOfDay(DateUtil.date(endDate));
        //Date.from(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay(ZoneId.systemDefault()).toInstant());
        return ObjectRestResponse.succ(vehicleModelCalendarPriceBiz.findVehicleModelCalendarPriceByDateAndVehilceIdAndUserId(startDateDay, endDateDay, vehicleModelId, userId));
    }

    @GetMapping(value = "/app/price", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ObjectRestResponse<List<VehicleModelCalendarPriceDTO>> findVehicleModelCalendarPriceByDateForApp(@RequestParam(value = "startDate") Long startDate,
                                                                                                            @RequestParam(value = "endDate") Long endDate,
                                                                                                            @RequestParam(value = "vehicleModelId") Integer vehicleModelId,
                                                                                                            AppUserDTO appUserDTO) {

        Date startDateDay = DateUtil.beginOfDay(DateUtil.date(startDate));
        Date endDateDay = DateUtil.beginOfDay(DateUtil.date(endDate));
        return ObjectRestResponse.succ(vehicleModelCalendarPriceBiz.findVehicleModelCalendarPriceByDateAndVehilceIdAndUserId(startDateDay, endDateDay, vehicleModelId, appUserDTO.getUserid()));
    }

}
