package com.xxfc.platform.order.pojo.order;

import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderMemberDetail;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.vehicle.entity.VehicleUserLicense;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

@Data
public class OrderPageVO extends BaseOrder {
    public static final String TYPE = "type=";
    public static final String NO = "no=";

    OrderRentVehicleDetail orderRentVehicleDetail;

    OrderTourDetail orderTourDetail;

    OrderMemberDetail orderMemberDetail;

    List<VehicleUserLicense> vehicleUserLicenses;

    private String username;

    private String vehicalNumberPlat;

    private String qrcodeStr;

    /**
     * 违章预备金
     */
    private BigDecimal illegalReserve;

    private OrderVehicleCrosstownDto orderVehicleCrosstownDto;

    public void setQrcodeStr(String prefix) {
        this.qrcodeStr = prefix+ "?"+ TYPE+ getType()+ "&"+ NO+ getNo();
    }
}
