package com.xxfc.platform.universal.constant;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/17 15:22
 */
public enum AliPayErrorEnum {
    PAYEE_USER_INFO_ERROR("支付宝账号和姓名不匹配，请确认姓名是否正确", "请联系收款方确认收款用户姓名正确性"),
    PAYER_USER_INFO_ERROR("付款用户姓名或其它信息不一致", "请检查接口传递的付款方用户姓名正确性。"),
    PAYER_DATA_INCOMPLETE("根据监管部门的要求，需要付款用户补充身份信息才能继续操作", "根据监管部门的要求，需要付款用户登录支付宝站内或手机客户端补充身份信息才能继续操作"),
    CERT_MISS_ACC_LIMIT("您连续10天余额账户的资金都超过5000元，根据监管部门的要求，需要付款用户补充身份信息才能继续操作", "您连续10天余额账户的资金都超过5000元，根据监管部门的要求，需要付款用户登录支付宝站内或手机客户端补充身份信息才能继续操作"),
    PAYEE_ACC_OCUPIED("该手机号对应多个支付宝账户，请传入收款方姓名确定正确的收款账号", "如果未传入payee_real_name，请传递payee_real_name；如果传递了payee_real_name，是因为收款登录号对应多个账户且账户名相同，请联系收款方更换登录号"),
    ACCOUNT_NOT_EXIST("根据监管部门的要求，请补全你的身份信息，开立余额账户", "请付款方登录支付宝站内或手机客户端补全身份信息"),
    PAYER_CERT_EXPIRED("根据监管部门的要求，需要付款用户更新身份信息才能继续操作", "根据监管部门的要求，需要付款用户登录支付宝站内或手机客户端更新身份信息才能继续操作"),
    PERMIT_NON_BANK_LIMIT_PAYEE("根据监管部门的要求，对方未完善身份信息或未开立余额账户，无法收款", "请联系收款方登录支付宝站内或手机客户端完善身份信息后，重试"),
    EXCEED_LIMIT_PERSONAL_SM_AMOUNT("转账给个人支付宝账户单笔最多5万元", "转账给个人支付宝账户单笔最多5万元。"),
    EXCEED_LIMIT_ENT_SM_AMOUNT("转账给企业支付宝账户单笔最多10万元", "转账给企业支付宝账户单笔最多10万元"),
    EXCEED_LIMIT_SM_MIN_AMOUNT("单笔最低转账金额0.1元", "请修改转账金额"),
    EXCEED_LIMIT_DM_MAX_AMOUNT("单日最多可转100万元", "单日最多可转100万元"),
    EXCEED_LIMIT_UNRN_DM_AMOUNT("收款账户未实名，单日最多可收款1000元", "收款账户未实名，单日最多可收款1000元"),
    PAYER_PAYEE_CANNOT_SAME("收付款方不能相同", "请检查一下收款方信息填写是否为付款方本人");
    private String subReason;
    private String solution;

    AliPayErrorEnum(String subReason, String solution) {
        this.subReason = subReason;
        this.solution = solution;
    }

    public String getSubReason() {
        return subReason;
    }

    public void setSubReason(String subReason) {
        this.subReason = subReason;
    }

    public String getSolution() {
        return solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }
}
