package com.xxfc.platform.order.rest.background;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.biz.rpc.OrderListBiz;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping(value = "/count")
public class OrderListController {

    @Autowired
    OrderListBiz orderListBiz;

    @GetMapping("/list")
    public ObjectRestResponse<List<OrderPageVO>> getOrderList(@RequestParam("dateTime")Long dateTime, @RequestParam("type")Integer type, @RequestParam("status")Integer status) {
        return orderListBiz.getOrderList(dateTime, type, status);
    }

}
