package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.MyWalletBiz;
import com.github.wxiaoqi.security.admin.biz.MyWalletCathBiz;
import com.github.wxiaoqi.security.admin.dto.WalletCathFindDTO;
import com.github.wxiaoqi.security.admin.vo.WalletCathAdminVo;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/17 19:50
 */
@RestController
@RequestMapping("/walletcath/admin")
public class WalletCathAdminController {

      @Autowired
     private MyWalletCathBiz myWalletCathBiz;

      @Autowired
      private MyWalletBiz myWalletBiz;

      @GetMapping("/page")
     public ObjectRestResponse<PageDataVO<WalletCathAdminVo>> listWalletCathWithPage(WalletCathFindDTO walletCathFindDTO){

          PageDataVO<WalletCathAdminVo> walletCathAdminVoPage =  myWalletCathBiz.listWalletCathWithPage(walletCathFindDTO);
          return ObjectRestResponse.succ(walletCathAdminVoPage);
      }
    @PostMapping("/verifyCath")
    @ApiOperation("提现审核")
    public ObjectRestResponse  verifyCath(
            @RequestParam(value = "cathId",defaultValue = "0") Integer cathId,
            @RequestParam(value = "reason",defaultValue = "") String reason,
            @RequestParam(value = "status",defaultValue = "1") Integer status){
        try {
            return  myWalletBiz.verifyCath(cathId,reason,status);
        }catch (Exception e) {
            throw new BaseException(e);
        }
    }
}
