package com.github.wxiaoqi.security.admin.handler;


import cn.hutool.json.JSONUtil;
import com.github.wxiaoqi.security.admin.biz.AppUserRelationBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserSellingWaterBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import com.rabbitmq.client.Channel;
import com.xxfc.platform.order.pojo.mq.OrderMQDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.support.AmqpHeaders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.github.wxiaoqi.security.admin.config.RabbitAdminConfig.ORDER_RELATION_QUEUE;

@Component
@Slf4j
public class RelationMQHandler {

    @Autowired
    AppUserRelationBiz relationBiz;

    /**
     * 永久关系绑定
     * @param
     */
    @RabbitListener(queues = ORDER_RELATION_QUEUE)
    public void integralHandler(Message message, @Headers Map<String, Object> headers, Channel channel) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable() {
            @Override
            public void run() {
                try {
                    String messageId = message.getMessageProperties().getMessageId();
                    String msg = new String(message.getBody(), "UTF-8");
                    log.info("接收到的消息-----msg===="+msg);
                    OrderMQDTO orderMQDTO = JSONUtil.toBean(msg, OrderMQDTO.class);
                    Integer sign=orderMQDTO.getSign();
                    Integer userId=orderMQDTO.getUserId();
                    log.info("接收到的消息-----sign===="+sign+"-----userId===="+userId);
                    relationBiz.foreverBind(userId);
                    executorService.shutdown();
                    Long deliveryTag = (Long) headers.get(AmqpHeaders.DELIVERY_TAG);
                    // 手动签收
                    channel.basicAck(deliveryTag, false);
                } catch (Exception e) {
                    log.info("接收到的消息失败");
                    try {
                        channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                    } catch (IOException i) {
                        i.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        });
    }



}
