package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.bo.PromoteBO;
import com.github.wxiaoqi.security.admin.bo.UserIncomeBo;
import com.github.wxiaoqi.security.admin.bo.UserTeamMemberBo;
import com.github.wxiaoqi.security.admin.entity.AppUserDetail;
import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.vo.UserTeamMemberVo;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/11 14:44
 */
@Transactional
@Service
public class UserBusinessBiz {

    @Autowired
    private AppUserRelationBiz appUserRelationBiz;

    @Autowired
    private AppUserSellingWaterBiz appUserSellingWaterBiz;

    @Autowired
    private AppUserLoginBiz appUserLoginBiz;

    @Autowired
    private AppUserDetailBiz appUserDetailBiz;

    public UserTeamMemberVo findTeamMemberPageByUserId(Integer userId, Integer pageNo, Integer pageSize) {

        UserTeamMemberVo userTeamMemberVo = new UserTeamMemberVo();

        PageDataVO<UserIncomeBo> dataVO = appUserSellingWaterBiz.findMemberIdAndIncomeMapByMemberIds(userId, pageNo, pageSize);
        List<UserIncomeBo> data = dataVO.getData();
        if (CollectionUtils.isEmpty(data)) {
            userTeamMemberVo.setPageNum(pageNo);
            userTeamMemberVo.setPageSize(pageSize);
            userTeamMemberVo.setTotalIncome(new BigDecimal(0));
            userTeamMemberVo.setUserTeamMemberBos(Collections.EMPTY_LIST);
            return userTeamMemberVo;
        }

        Map<Integer, UserIncomeBo> userIdAndIncomMap = data.stream().collect(Collectors.toMap(UserIncomeBo::getUserId, Function.identity()));
        List<Integer> memberIds = data.stream().map(UserIncomeBo::getUserId).collect(Collectors.toList());
        Map<Integer, AppUserLogin> userIdAndAppUserLoginMap = appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(memberIds);
        Map<Integer, AppUserDetail> userIdAndAppUserDetailMap = appUserDetailBiz.findUserIdAndUserDetailMapByMemberIds(memberIds);

        List<UserTeamMemberBo> userTeamMemberBos = new ArrayList<>();
        UserTeamMemberBo userTeamMemberBo;
        BigDecimal totalIncome = new BigDecimal(0);
        for (Integer memberId : memberIds) {

            userTeamMemberBo = new UserTeamMemberBo();
            userTeamMemberBo.setLeagueTime(userIdAndIncomMap.get(memberId).getLeagueTime());
            userTeamMemberBo.setUserId(memberId);

            if (userIdAndAppUserLoginMap != null) {
                AppUserLogin appUserLogin = userIdAndAppUserLoginMap.get(memberId);
                if (appUserLogin == null) {
                    continue;
                }
                userTeamMemberBo.setUserName(appUserLogin.getUsername());
            }
            if (userIdAndAppUserDetailMap != null) {
                AppUserDetail appUserDetail = userIdAndAppUserDetailMap.get(memberId);
                userTeamMemberBo.setHeadUrl(appUserDetail == null ? "" : appUserDetail.getHeadimgurl());
                userTeamMemberBo.setNickName(appUserDetail == null ? "" : appUserDetail.getNickname());
                userTeamMemberBo.setRealName(appUserDetail == null ? "" : appUserDetail.getRealname());
            }
            BigDecimal income = userIdAndIncomMap.get(memberId).getIncome() == null ? new BigDecimal(0) : userIdAndIncomMap.get(memberId).getIncome();
            userTeamMemberBo.setIncome(income);
            totalIncome = totalIncome.add(income);
            userTeamMemberBos.add(userTeamMemberBo);
        }
        userTeamMemberBos.sort(Comparator.comparing(UserTeamMemberBo::getIncome).reversed());
        userTeamMemberVo.setPageNum(dataVO.getPageNum());
        userTeamMemberVo.setPageSize(dataVO.getPageSize());
        userTeamMemberVo.setTotalCount(dataVO.getTotalCount().intValue());
        userTeamMemberVo.setTotalPage(dataVO.getTotalPage());
        userTeamMemberVo.setUserTeamMemberBos(userTeamMemberBos);
        userTeamMemberVo.setTotalIncome(totalIncome);
        return userTeamMemberVo;
    }

    public PromoteBO getPromoteBoByUserId(Integer userId) {

        PromoteBO promoteBO = new PromoteBO();
        Integer leaderId = appUserRelationBiz.findLeaderIdByMemberId(userId);
        Map<Integer, Integer> memberStateAndCountMap = appUserRelationBiz.findMemberSateAndCountMapByLeaderId(userId);

        if (leaderId != 0) {
            Map<Integer, AppUserLogin> userIdAndUserLoginMap = appUserLoginBiz.findUserIdAndUserLoginMapByMemberIds(Arrays.asList(leaderId));
            Map<Integer, AppUserDetail> userIdAndUserDetailMap = appUserDetailBiz.findUserIdAndUserDetailMapByMemberIds(Arrays.asList(leaderId));
            if (!userIdAndUserLoginMap.isEmpty()) {
                promoteBO.setLeaderUsername(userIdAndUserLoginMap.get(leaderId).getUsername());
            }
            if (!userIdAndUserDetailMap.isEmpty()) {
                AppUserDetail appUserDetail = userIdAndUserDetailMap.get(leaderId);
                promoteBO.setLeaderHeadUrl(StringUtils.isEmpty(appUserDetail.getHeadimgurl()) ? "" : appUserDetail.getHeadimgurl());
                promoteBO.setLeaderUsername(StringUtils.isEmpty(appUserDetail.getRealname()) ? promoteBO.getLeaderUsername() : appUserDetail.getRealname());
            }
        }
        promoteBO.setInviteNumber(memberStateAndCountMap.get(0));
        promoteBO.setActivatedNumber(memberStateAndCountMap.get(1));

        BigDecimal totalIncome = appUserSellingWaterBiz.selectTotalIncomeByUserId(userId);
        promoteBO.setTotalIncome(totalIncome == null ? new BigDecimal(0) : totalIncome);
        return promoteBO;
    }
}
