/*
 * Decompiled with CFR 0.152.
 */
package ytx.org.apache.http.impl.io;

import java.io.IOException;
import ytx.org.apache.http.Header;
import ytx.org.apache.http.HeaderIterator;
import ytx.org.apache.http.HttpException;
import ytx.org.apache.http.HttpMessage;
import ytx.org.apache.http.annotation.NotThreadSafe;
import ytx.org.apache.http.io.HttpMessageWriter;
import ytx.org.apache.http.io.SessionOutputBuffer;
import ytx.org.apache.http.message.BasicLineFormatter;
import ytx.org.apache.http.message.LineFormatter;
import ytx.org.apache.http.params.HttpParams;
import ytx.org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        if (buffer == null) {
            throw new IllegalArgumentException("Session input buffer may not be null");
        }
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.DEFAULT;
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        if (message == null) {
            throw new IllegalArgumentException("HTTP message may not be null");
        }
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

