package com.xxfc.platform.vehicle.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.google.common.collect.Lists;
import com.xxfc.platform.vehicle.entity.Constant;
import com.xxfc.platform.vehicle.entity.Vehicle;
import com.xxfc.platform.vehicle.mapper.VehicleMapper;
import com.xxfc.platform.vehicle.pojo.ResultVehicleVo;
import com.xxfc.platform.vehicle.pojo.VehicleExcelVo;
import com.xxfc.platform.vehicle.pojo.VehiclePageQueryVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@Slf4j
public class VehicleInformationDownloadBiz extends BaseBiz<VehicleMapper, Vehicle> {

    @Autowired
    private VehicleBiz vehicleBiz;
    @Autowired
    private  ConstantBiz constantBiz;
    @Autowired
    private BranchCompanyVehicleCountBiz branchCompanyVehicleCountBiz;

    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");


    public List getByPageNotAllData(VehiclePageQueryVo vehiclePageQueryVo, List<Integer> companyList) throws Exception {
        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        if (companyList != null && companyList.size() > 0) {
            params.put("companyList", companyList);
        } else {
            params.put("companyList", Arrays.asList(-1));
        }

        return  mapper.getByPageNotAllData(params);
    }

    public List getByPage(VehiclePageQueryVo vehiclePageQueryVo) throws Exception  {

        Map<String, Object> params = PropertyUtils.describe(vehiclePageQueryVo);
        //处理预定日期相关参数
        vehicleBiz.adjustBookedInfoParam(params, vehiclePageQueryVo);
        params.get("yearMonthAndParam");
        if (vehiclePageQueryVo.getModelId() == null) {
            params.remove("modelId");
        }
        return  mapper.getByPage(params);
    }
    //getResultVehicleVoList
    public List<ResultVehicleVo> getResultVehicleVoList(String vehiclePageQueryVoJson, UserDTO userDTO) {
        VehiclePageQueryVo vehiclePageQueryVo = new VehiclePageQueryVo();
        try {
            if (StringUtils.isNotBlank(vehiclePageQueryVoJson)){
                vehiclePageQueryVo = JSON.parseObject(vehiclePageQueryVoJson, VehiclePageQueryVo.class);
                 vehiclePageQueryVo.setDownload(true);
            }
                if (userDTO.getDataAll() == 2) {
                    List<Integer> companyList = vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany());
                 return  getByPageNotAllData(vehiclePageQueryVo, companyList);
                }

          return   getByPage(vehiclePageQueryVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return new ArrayList();
    }


    public List<VehicleExcelVo> getList(String vehiclePageQueryVoJson, UserDTO userDTO) throws Exception  {
        List<Constant> constants = constantBiz.selectList(new Constant() {{
            setType(3);
        }});
        Map<Integer, List<Constant>> map = constants.parallelStream().collect(Collectors.groupingBy(Constant::getCode));

        List<ResultVehicleVo> resultVehicleVoList = getResultVehicleVoList(vehiclePageQueryVoJson, userDTO);
        ArrayList<VehicleExcelVo> arrayList = Lists.newArrayList();
        resultVehicleVoList.stream().forEach(result->{
            try {
                VehicleExcelVo build = VehicleExcelVo.builder()
                        .code(result.getCode())
                        .numberPlate(result.getNumberPlate())
                        .parkBranchCompanyName(result.getParkBranchCompanyName())
                        .status(result.getStatus())
                        .useTypeName(result.getUseTypeName())
                        .vehicleType(result.getVehicleType())
                        .belongToName(result.getBelongTo()!=null&&result.getBelongTo()==1?"欣新房车有限公司":result.getBelongToName())
                         .vin(result.getVin())
                        .engineNum(result.getEngineNum())
                         .insuranceCompany(result.getInsuranceCompany()!=null?map.get(result.getInsuranceCompany()).get(0).getVal():null)
                         .insuranceNo(result.getInsuranceNo())
                         .insuranceEndDate(result.getInsuranceEndDate())
                         .strongInsuranceCompany(result.getStrongInsuranceCompany()!=null?map.get(result.getStrongInsuranceCompany()).get(0).getVal():null)
                         .strongInsuranceNo(result.getInsuranceNo())
                         .strongInsuranceEndDate(result.getStrongInsuranceEndDate())
                        .build();
                arrayList.add(build);
            } catch (Exception e) {
                log.error(e.getMessage());
                log.error(e.getMessage(), e);
            }
        });
        return arrayList;

    }

}
