package com.xxfc.platform.vehicle.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.entity.BookRecordUpdateLog;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.mapper.BookRecordUpdateLogMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service
public class BookRecordUpdateLogBiz extends BaseBiz<BookRecordUpdateLogMapper, BookRecordUpdateLog> {

    @Autowired
    BranchCompanyBiz branchCompanyBiz;

    public ObjectRestResponse save(BookRecordUpdateLog bookRecordUpdateLog) {
        BookRecordUpdateLog oldValue = mapper.selectOne(bookRecordUpdateLog);
        if (oldValue != null) {
            return ObjectRestResponse.succ();
        }
        insertSelectiveRe(bookRecordUpdateLog);
        return ObjectRestResponse.succ();
    }

    public ObjectRestResponse<List<BookRecordUpdateLog>> selectByBookRecordId(Long bookRecordId) {
        Example example = new Example(BookRecordUpdateLog.class);
        example.createCriteria().andEqualTo("bookRecordId", bookRecordId);
        example.setOrderByClause("create_time desc");
        List<BookRecordUpdateLog> bookRecordUpdateLogs = selectByExample(example);
        for (BookRecordUpdateLog bookRecordUpdateLog : bookRecordUpdateLogs) {
            BranchCompany oldCompany = branchCompanyBiz.getById(bookRecordUpdateLog.getOldRetCompanyId());
            if (oldCompany != null) {
                bookRecordUpdateLog.setOldCompanyName(oldCompany.getName());
            }
            BranchCompany newCompany = branchCompanyBiz.getById(bookRecordUpdateLog.getNewRetCompanyId());
            if (newCompany != null) {
                bookRecordUpdateLog.setNewCompanyName(newCompany.getName());
            }
        }
        return ObjectRestResponse.succ(bookRecordUpdateLogs);
    }

}
