package com.xxfc.platform.activity.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;


/**
 * 我的优惠卷
 * 
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-06-21 14:34:49
 */
@Data
@Table(name = "user_coupon")
public class UserCoupon implements Serializable {
	private static final long serialVersionUID = 1L;
	
	    /**
    *  主键id
   */
    @Id
	@GeneratedValue(generator = "JDBC")
	@ApiModelProperty("主键id")
    private Integer id;
	
	    /**
     *  优惠卡券id
     */
    @Column(name = "coupon_id")
	@ApiModelProperty(value = "优惠卡券id")
    private Integer couponId;
	
	    /**
     *  用户id
     */
    @Column(name = "user_id")
	@ApiModelProperty(value = "用户id")
    private Integer userId;
	
	    /**
     *  券号
     */
    @Column(name = "ticker_no")
	@ApiModelProperty(value = "券号")
    private String tickerNo;
	
	    /**
     *  0-未使用；1-已使用
     */
    @Column(name = "is_use")
	@ApiModelProperty(value = "0-未使用；1-已使用")
    private Integer isUse;
	
	    /**
     *  使用订单号
     */
    @Column(name = "order_no")
	@ApiModelProperty(value = "使用订单号")
    private String orderNo;
	
	    /**
     *  领卷时间
     */
    @Column(name = "crt_time")
	@ApiModelProperty(value = "领卷时间", hidden = true )
    private Long crtTime;
	
    /**
     *  更新时间
     */
    @Column(name = "upd_time")
	@ApiModelProperty(value = "更新时间", hidden = true )
    private Long updTime;

	/**
	 *  开始时间
	 */
	@Column(name = "start_time")
	@ApiModelProperty(value = "开始时间", hidden = true )
	private Long startTime;

	/**
	 *  到期时间
	 */
	@Column(name = "expire_time")
	@ApiModelProperty(value = "到期时间", hidden = true )
	private Long expireTime;
	
    /**
     *  使用时间
     */
    @Column(name = "use_time")
	@ApiModelProperty(value = "使用时间")
    private Long useTime;

	/**
	 *  是否删除；0-正常；1-删除
	 */
	@Column(name = "is_del")
	@ApiModelProperty(value = "是否删除；0-正常；1-删除")
	private Integer isDel;

	/**
	 *  可使用门店ids
	 */
	@Column(name = "company_ids")
	@ApiModelProperty(value = "可使用门店ids")
	private String companyIds;

}
