package com.github.wxiaoqi.security.admin.rest.admin;

import com.github.wxiaoqi.security.admin.biz.BranchCompanyLevelBiz;
import com.github.wxiaoqi.security.admin.biz.CompanyInfoBiz;
import com.github.wxiaoqi.security.admin.entity.BranchCompanyLevel;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author Administrator
 */
@Slf4j
@RestController
@RequestMapping("backstage/companyLevel")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
@Api(tags = {"商家申请"})
public class AdminBranchCompanyLevelController extends BaseController<BranchCompanyLevelBiz, BranchCompanyLevel> {


    @Autowired
    CompanyInfoBiz companyInfoBiz;


    @GetMapping("getList")
    @ApiModelProperty("店铺等级列表")
    public  ObjectRestResponse getList() {
     return ObjectRestResponse.succ( baseBiz.getList());
    }



    @PostMapping("addOrUpd")
    @ApiModelProperty("店铺等级更新")
    public  ObjectRestResponse addOrUpd(@RequestBody BranchCompanyLevel branchCompanyLevel) {
        return baseBiz.addOrUpd(branchCompanyLevel);
    }




}
