package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.CompanyBaseBiz;
import com.xxfc.platform.vehicle.pojo.vo.CompanyBaseVo;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/8/23 12:16
 */
@RestController("companyBaseApp")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/company_base")
public class CompanyBaseController {

     private final  CompanyBaseBiz companyBaseBiz;


     @GetMapping("/app/unauth/detail/{id}")
    public ObjectRestResponse<CompanyBaseVo> findCompanyDetailById(@PathVariable(value = "id") Integer id){
          CompanyBaseVo companyBaseVo = companyBaseBiz.findCompanyDetailById(id);
         return ObjectRestResponse.succ(companyBaseVo);
     }

}
