package com.xxfc.platform.tour.biz;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.tour.dto.TourSpePriceDTO;
import com.xxfc.platform.tour.entity.TourGoodSpe;
import com.xxfc.platform.tour.entity.TourGoodSpePrice;
import com.xxfc.platform.tour.mapper.TourGoodSpePriceMapper;
import com.xxfc.platform.tour.vo.TourSpePriceVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 旅游商品规格表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 11:41:51
 */
@Service
@Slf4j
public class TourGoodSpeBiz extends BaseBiz<TourGoodSpePriceMapper, TourGoodSpePrice> {

    @Autowired
    TourGoodDetailBiz goodDetailBiz;

    public ObjectRestResponse<TourSpePriceVo> getPricesByuserid(TourSpePriceDTO priceDto) {
        if (priceDto == null || priceDto.getUserId() == null || priceDto.getUserId() == 0 ||
                priceDto.getNumber() == null || priceDto.getNumber() == 0||priceDto.getSpeId()==null) {
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        TourSpePriceVo priceVo = new TourSpePriceVo();
        Integer speId = priceDto.getSpeId();
        Integer number = priceDto.getNumber();
        Integer childNumber = priceDto.getChildNumber() == null ? 0 : priceDto.getChildNumber();
        if (speId != null) {
            TourGoodSpePrice spePrice = mapper.selectByPrimaryKey(speId);
            if (spePrice != null) {
                Integer level = priceDto.getLevel();
                priceVo.setUserId(priceDto.getUserId());
                priceVo.setLevel(priceDto.getLevel());
                priceVo.setStock(spePrice.getStock());
                BigDecimal price = spePrice.getPrice();
                BigDecimal childPrice = spePrice.getChildPrice();
                priceVo.setOriginalPrice(price);
                priceVo.setChildOriginalPrice(childPrice);
                BigDecimal totalPrice = price.multiply(new BigDecimal(number)).setScale(2, RoundingMode.HALF_UP);
                BigDecimal totalChildPrice = childNumber > 0 ? price.multiply(new BigDecimal(childNumber)).setScale(2, RoundingMode.HALF_UP): new BigDecimal("0.00");
                priceVo.setTotalPrice(totalPrice);
                priceVo.setTotalChildPrice(totalChildPrice);
                if (level != null && level > 0) {
                    String memberPrice = spePrice.getMemberPrice();
                    JSONArray array = JSONArray.parseArray(memberPrice);
                    if (array.size() > 0) {
                        for (Object obj : array) {
                            JSONObject jsonObject = JSONObject.parseObject(obj.toString());
                            Integer levels = jsonObject.getInteger("level");
                            if (level == levels) {
                                String money = jsonObject.getString("price");
                                price = new BigDecimal(StringUtils.isNotBlank(money) ? money : "0.00");
                                String childMoney = jsonObject.getString("child_price");
                                childPrice = new BigDecimal(StringUtils.isNotBlank(childMoney) ? childMoney : "0.00");
                                break;
                            }
                        }
                    }
                }
                    totalPrice = price.multiply(new BigDecimal(number)).setScale(2, RoundingMode.HALF_UP);
                    totalChildPrice = childNumber > 0 ? childPrice.multiply(new BigDecimal(childNumber)).setScale(2, RoundingMode.HALF_UP): new BigDecimal("0.00");
                    priceVo.setPrice(price);
                    priceVo.setChildPrice(childPrice);
                    priceVo.setRealPrice(totalPrice);
                    priceVo.setRealChildPrice(totalChildPrice);
                    return ObjectRestResponse.succ(priceVo);
                }
            }
            return ObjectRestResponse.createDefaultFail();

        }

        //减库存
       public  ObjectRestResponse cutStock(Integer speId,Integer number,Integer type) {
           TourGoodSpePrice spePrice = mapper.selectByPrimaryKey(speId);
           if(type==1){
               if (spePrice != null && spePrice.getStock() > 0 && spePrice.getStock() >= number) {
                    if (!checkTime(spePrice.getStartTime())){
                        return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "该日期已超过系统限制");
                    }
                   mapper.updStockById(speId, number,type);
               } else {
                   return ObjectRestResponse.createFailedResult(ResultCode.STOCK_CODE, "库存不足");
               }
           }else {
               mapper.updStockById(speId, number,type);
           }
           return ObjectRestResponse.succ();
       }

    //删除
    public  void delGoodSpe(Integer goodId, List<Integer> ids){ mapper.delSpe(goodId,ids);}


    public Date selectDepartureDataBySpeId(Integer speIds) {
        TourGoodSpePrice tourGoodSpePrice = new TourGoodSpePrice();
        tourGoodSpePrice.setId(speIds);
        TourGoodSpePrice spePrice = mapper.selectOne(tourGoodSpePrice);
        return spePrice.getStartTime();
    }

    public  boolean checkTime(Date startTime){
        try {
            Date endTime=new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            long startDateTime = dateFormat.parse(dateFormat.format(startTime)).getTime();
            long endDateTime = dateFormat.parse(dateFormat.format(endTime)).getTime();
            if (startDateTime<=endDateTime){
                return  false;
            }
            int days=(int)((startDateTime - endDateTime) / (1000 * 3600 * 24));
            int tourDays=goodDetailBiz.getTourDays();
            if (days>=0&&days>=tourDays){
                return  true;
            }
            return  false;
        }catch (Exception e){
            e.printStackTrace();
            return false;
        }
    }
}