package com.xxfc.platform.universal.biz;


import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jpush.api.JPushClient;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.PushPayload;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.universal.service.SmsService;
import com.xxfc.platform.universal.utils.CCPRestSmsUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JPushBiz {


    @Value("${universal.MASTER_SECRET}")
    private  String MASTER_SECRET;
    @Value("${universal.APP_KEY}")
    private  String APP_KEY;

    //推送给所有平台设备
    public ObjectRestResponse jpushToAllPlat(String title){
        ClientConfig clientConfig = ClientConfig.getInstance();
        final JPushClient jpushClient = new JPushClient(MASTER_SECRET, APP_KEY, null, clientConfig);
        PushPayload payload = PushPayload.alertAll(title);
        try {
            PushResult result = jpushClient.sendPush(payload);
            log.debug("\n推送结果:"+result);
           return  ObjectRestResponse.succ();
        } catch (APIConnectionException e) {
            // Connection error, should retry later
            log.debug("\nConnection error, should retry later"+e);
            return  ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,e.getMessage());
        } catch (APIRequestException e) {
            // Should review the error, and fix the request
            log.debug("\nShould review the error, and fix the request"+ e);
            log.debug("\nHTTP Status: " + e.getStatus());
            log.debug("\nError Code: " + e.getErrorCode());
            log.debug("\nError Message: " + e.getErrorMessage());
            return  ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,e.getMessage());
        }
    }


}
