package com.xxfc.platform.order.rest.background;


import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.rest.UserRestInterface;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.biz.CompanyWalletBiz;
import com.xxfc.platform.order.biz.CompanyWalletCathBiz;
import com.xxfc.platform.order.biz.CompanyWalletDetailBiz;
import com.xxfc.platform.order.entity.CompanyWalletCath;
import com.xxfc.platform.order.entity.CompanyWalletDetail;
import com.xxfc.platform.order.pojo.dto.WalletCathApplyDTO;
import com.xxfc.platform.order.pojo.dto.WalletCathDTO;
import com.xxfc.platform.order.pojo.dto.WalletDTO;
import com.xxfc.platform.order.pojo.dto.WalletDetailDTO;
import com.xxfc.platform.order.pojo.vo.CompanyWalletDetailVo;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("admin/wallet")
public class AdminCompanyWalletDetailController extends BaseController<CompanyWalletDetailBiz, CompanyWalletDetail> implements UserRestInterface {

    @Autowired
    UserFeign userFeign;

    @Override
    public UserFeign getUserFeign() {
        return userFeign;
    }


    @Autowired
    CompanyWalletCathBiz walletCathBiz;

    @Autowired
    CompanyWalletBiz walletBiz;


    @RequestMapping(value = "selectList", method = RequestMethod.GET)
    @ApiModelProperty(value = "营收明细列表")
    public ObjectRestResponse<PageDataVO<CompanyWalletDetailVo>> selectList(WalletDetailDTO walletDetailDTO) {
        setPowerData(walletDetailDTO,true);
        return ObjectRestResponse.succ(baseBiz.selectList(walletDetailDTO));
    }


    @RequestMapping(value = "sumAmount", method = RequestMethod.GET)
    @ApiModelProperty(value = "营收统计")
    public ObjectRestResponse sumAmount(WalletDetailDTO walletDetailDTO) {
        setPowerData(walletDetailDTO,true);
        return ObjectRestResponse.succ(baseBiz.getSumAmount(walletDetailDTO));
    }



    @RequestMapping(value = "cath/selectList", method = RequestMethod.GET)
    @ApiModelProperty(value = "提现明细列表")
    public ObjectRestResponse<PageDataVO<CompanyWalletDetailVo>> cathSelectList(WalletCathDTO walletCathDTO) {
        setPowerData(walletCathDTO,true);
        return ObjectRestResponse.succ(walletCathBiz.selectList(walletCathDTO));
    }


    @RequestMapping(value = "amount/selectList", method = RequestMethod.GET)
    @ApiModelProperty(value = "钱包列表")
    public ObjectRestResponse<PageDataVO<CompanyWalletDetailVo>> amountSelectList(WalletDTO walletDTO) {
        setPowerData(walletDTO,true);
        return ObjectRestResponse.succ(walletBiz.selectList(walletDTO));
    }


    @RequestMapping(value = "applyCath", method = RequestMethod.POST)
    @ApiModelProperty(value = "提现申请")
    public ObjectRestResponse applyCath(@RequestBody CompanyWalletCath walletCathDTO) {
        walletCathBiz.applyCath(walletCathDTO);
        return ObjectRestResponse.succ();
    }


    @RequestMapping(value = "applyCathList", method = RequestMethod.POST)
    @ApiModelProperty(value = "提现申请List")
    public ObjectRestResponse applyCathList(@RequestBody WalletCathApplyDTO walletCathApplyDTO) {
        walletCathBiz.applyCathList(walletCathApplyDTO);
        return ObjectRestResponse.succ();
    }

    @RequestMapping(value = "withDrawProcess", method = RequestMethod.POST)
    @ApiModelProperty(value = "提现审核")
    public ObjectRestResponse withDrawProcess(@RequestBody CompanyWalletCath companyWalletCath) {
        walletCathBiz.withDrawProcess(companyWalletCath);
        return ObjectRestResponse.succ();
    }


}