package com.xxfc.platform.activity.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.activity.biz.ActivityUserJoinBiz;
import com.xxfc.platform.activity.biz.UserCouponBiz;
import com.xxfc.platform.activity.vo.UserCouponVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

@RestController
@RequestMapping("user")
public class UserCouponController extends ActivityBaseController<UserCouponBiz> {


    @Autowired
    ActivityUserJoinBiz joinBiz;


    @ApiOperation("用户自动领取新人卷")
    @RequestMapping(value = "/auth/led", method = RequestMethod.POST)
    public String led(@RequestParam(value = "userId",defaultValue = "0") Integer userId) {
        return baseBiz.authledCoupon(userId);
    }

    /**
     *
     * @param type  0-未使用；1-已使用；3-已过期
     * @param channel 1-租车；2-旅游；null-全部
     * @return
     */
    @ApiOperation("我的优惠卷")
    @RequestMapping(value = "/coupon/list", method = RequestMethod.GET)
    public ObjectRestResponse list(@RequestParam(value = "type",defaultValue = "0") Integer type,
                                   @RequestParam(value = "channel",required = false) Integer channel,
                                   @RequestParam(value = "amount",defaultValue = "0.00") BigDecimal amount) {
        AppUserDTO userInfo = getUserInfo();
        Integer userId = userInfo.getUserid();
        if(userId==null){
            return ObjectRestResponse.createDefaultFail();
        }
        return baseBiz.getCouponList(userId,type,channel,amount);
    }

    @ApiOperation("单个优惠卷信息")
    @RequestMapping(value = "/info/{no}", method = RequestMethod.GET)
    public UserCouponVo info(@PathVariable String no) {
        return baseBiz.getUserCoupon(no);
    }


    @ApiOperation("优惠卷使用")
    @RequestMapping(value = "/use", method = RequestMethod.POST)
    public BigDecimal use(
            @RequestParam(value = "userId",defaultValue ="0" ) Integer userId,
            @RequestParam(value = "tickerNo",defaultValue ="" ) String tickerNo,
            @RequestParam(value = "orderNo",defaultValue ="" ) String orderNo,
            @RequestParam(value = "channel",defaultValue ="1" ) Integer channel,
            @RequestParam(value = "amount",defaultValue ="0.00" ) BigDecimal amount,
            @RequestParam(value = "type",defaultValue ="1" ) Integer type
    ) {
        return   baseBiz.useTickerNo(userId,tickerNo,orderNo,channel,amount,type);
    }

    @ApiOperation("优惠卷取消使用")
    @RequestMapping(value = "/cancelUse", method = RequestMethod.POST)
    public ObjectRestResponse cancelUse(
            @RequestParam(value = "TickerNo",defaultValue ="" ) String TickerNo){
        baseBiz.cancelTickerNo(TickerNo);
        return ObjectRestResponse.succ();
    }

    @ApiOperation("领取优惠卷")
    @RequestMapping(value = "/coupon/led", method = RequestMethod.POST)
    public ObjectRestResponse led() {
        AppUserDTO userInfo = getUserInfo();
        Integer userId = userInfo.getUserid();
        if (userId == null) {
            return ObjectRestResponse.createDefaultFail();
        }
        return  joinBiz.receiveCoupn(userId);
    }





}