package com.xxfc.platform.activity.biz;

import com.github.wxiaoqi.security.admin.dto.RegisterQueueDTO;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.xxfc.platform.activity.entity.ActivityPopularizeLog;
import com.xxfc.platform.activity.entity.ActivityPopularizeRelation;
import com.xxfc.platform.activity.entity.ActivityPopularizeUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.activity.entity.ActivityPopularize;
import com.xxfc.platform.activity.mapper.ActivityPopularizeMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;

/**
 * 推广活动（邀请有礼）
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-05 15:23:04
 */
@Service
public class ActivityPopularizeBiz extends BaseBiz<ActivityPopularizeMapper,ActivityPopularize> {

    @Autowired
    ActivityPopularizeRelationBiz relationBiz;

    @Autowired
    ActivityPopularizeBiz popularizeBiz;

    @Autowired
    ActivityPopularizeUserBiz popularizeUserBiz;

    @Autowired
    ActivityPopularizeLogBiz popularizeLogBiz;

    @Autowired
    UserFeign userFeign;

    public static final String POPULARIZE_0101 = "0101";

    public void handleRegister(RegisterQueueDTO registerQueueDTO) {

        String activityCode = registerQueueDTO.getInParamDTO().getActivityCode();
        AppUserDTO appUserDTO = userFeign.userDetailById(registerQueueDTO.getAppUserId()).getData();

        //获取活动code,并且注册来源是app 并且 是邀请注册
        if(POPULARIZE_0101.equals(registerQueueDTO.getInParamDTO().getActivityCode())
                && RegisterQueueDTO.SIGN_LOGIN.equals(registerQueueDTO.getSign())) {

            ActivityPopularize activityPopularize = popularizeBiz.selectOne(new ActivityPopularize(){{
                setCode(activityCode);
            }});

            Integer majorUserId = Integer.valueOf(appUserDTO.getInviterAccount());

            //添加活动关系
            relationBiz.insertSelective(new ActivityPopularizeRelation(){{
                setPopularizeId(activityPopularize.getId());
                setMajorUserId(majorUserId);
                setMinorUserId(appUserDTO.getUserid());
            }});

            ActivityPopularizeLog popularizeLog = popularizeLogBiz.selectOne(new ActivityPopularizeLog(){{
                setUserId(majorUserId);
                setItemId(3);
            }});

            //生成任务项
            if(null == popularizeLog){
                popularizeLogBiz.insertSelectiveRe(new ActivityPopularizeLog(){{
                    setItemId(3);
                    setUserId(majorUserId);
                    setStatus(SYS_FALSE);
                    setPopularizeId(activityPopularize.getId());
                }});
            }

            //查出majorUser参与活动信息
            ActivityPopularizeUser activityPopularizeUser = popularizeUserBiz.selectOne(new ActivityPopularizeUser(){{
                setUserId(majorUserId);
                setPopularizeId(activityPopularize.getId());
            }});

            //任务没有完成
            if(!SYS_TRUE.equals(activityPopularizeUser.getStatus())) {
                //检查是否满足奖励
                if(relationBiz.selectList(new ActivityPopularizeRelation(){{
                    setMajorUserId(appUserDTO.getUserid());
                    setPopularizeId(activityPopularize.getId());
                }}).size() >= 10) {
                    activityPopularizeUser.setStatus(SYS_TRUE);
                    popularizeUserBiz.updateSelectiveById(activityPopularizeUser);
                    popularizeLog.setStatus(SYS_TRUE);
                    popularizeLogBiz.updateSelectiveById(popularizeLog);
                }
            }
        }
    }
}