package com.xinxincaravan.caravan.vehicle.entity;

import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.util.Date;

/**
 *车辆相关预警消息
 *
 */
@Data
public class VehicleWarningRule {

    @Id
    @GeneratedValue(strategy= GenerationType.IDENTITY)
    private Integer id;
    /**
     * 消息类型，详见VehicleMsgType
     */
    private Integer msgType;

    /**
     * js函数用于检查是否符合规则
     */
    private String jsFunctionCheck;

    /**
     * js表达式用于拼接消息内容
     */
    private String jsExpressionMsg;
    /**
     * js表达式用于生成消息唯一键
     */
    private String jsFunctionMsgKey;

    /**
     * 备注
     */
    private String remark;

    private Date createTime;

    private Date updateTime;
}
