package com.github.wxiaoqi.security.admin.biz;

import cn.hutool.core.date.DateTime;
import com.github.wxiaoqi.security.admin.entity.MyWallet;
import com.github.wxiaoqi.security.admin.entity.MyWalletDetail;
import com.github.wxiaoqi.security.admin.mapper.MyWalletDetailMapper;
import com.github.wxiaoqi.security.admin.mapper.MyWalletMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;

/**
 * 钱包
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-09 10:00:42
 */
@Service
@Slf4j
public class MyWaterBiz extends BaseBiz<MyWalletMapper, MyWallet>{


    @Autowired
    MyWalletDetailBiz walletDetailBiz;


    //我的钱包入账
    public  void updMyWater(Integer userId, Integer orderId,BigDecimal amount){
        log.info("---我的钱包入账----userId==="+userId+"----orderId===="+orderId+"----amount===="+amount);
        MyWallet wallet=new MyWallet();
        wallet.setUserId(userId);
        wallet=selectOne(wallet);
        //进账之前余额
        BigDecimal oldBalance=new BigDecimal("0.00");
        BigDecimal balance=new BigDecimal("0.00");
        //进账总额(元)
        BigDecimal totalAmount=new BigDecimal("0.00");
        //今日收益
        BigDecimal todayAmount=new BigDecimal("0.00");
        //未入账金额
        BigDecimal unbooked=new BigDecimal("0.00");
        Integer id=0;
        if(wallet==null){
            wallet=new MyWallet();
            wallet.setUserId(userId);
            totalAmount=amount;
            todayAmount=amount;
            balance=amount;
        }else {
            id=wallet.getId();
            oldBalance=wallet.getBalance();
            balance=wallet.getBalance().add(amount);
            totalAmount=wallet.getTotalAmount().add(amount);
            Long lastTime=wallet.getLastIntime();
            todayAmount=amount;
            if (lastTime!=null&&(lastTime==0||isToday(lastTime))){
                todayAmount=wallet.getTodayAmount().add(amount);
            }
            unbooked=wallet.getUnbooked().subtract(unbooked);

        }
        log.info("---我的钱包入账----userId==="+userId+"----balance===="+balance+"----totalAmount===="+totalAmount+"---todayAmount==="+todayAmount+"---unbooked=="+unbooked);
        MyWalletDetail walletDetail=new MyWalletDetail();
        walletDetail.setUserId(userId);
        walletDetail.setSource(1);
        walletDetail.setCono(orderId);
        walletDetail.setItype(1);
        walletDetail.setAmount(amount);
        walletDetail.setBalance(oldBalance);
        walletDetailBiz.insertSelective(walletDetail);
        Long time=System.currentTimeMillis();
        wallet.setBalance(balance);
        wallet.setTodayAmount(todayAmount);
        wallet.setTotalAmount(totalAmount);
        wallet.setUnbooked(unbooked);
        wallet.setLastIntime(time);
        wallet.setUpdTime(time);
        if(id>0){
        mapper.updMyWater(wallet);
        }else {
        wallet.setCrtTime(time);
        insertSelective(wallet);
        }
        log.info("---我的钱包入账----userId==="+userId+"----成功");
    }

    // 这个时间戳是不是今天
    public boolean  isToday(long time) {
        boolean isToday = false;
        Date date;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            date = sdf.parse(sdf.format(new Date()));
            if (time < date.getTime() && time > date.getTime()) {
                isToday = true;
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return isToday;
    }

    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public int createWalletByUserId(Integer userId){
        MyWallet myWallet = new MyWallet();
        myWallet.setUserId(userId);
        myWallet.setCrtTime(Instant.now().toEpochMilli());
        myWallet.setUpdTime(Instant.now().toEpochMilli());
        return mapper.insertSelective(myWallet);
    }
}