package com.xxfc.platform.vehicle.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.vehicle.biz.VehicleHolidayPriceInfoBiz;
import com.xxfc.platform.vehicle.entity.VehicleHolidayPriceInfo;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("vehicleHolidayPriceInfo")
public class VehicleHolidayPriceInfoController extends BaseController<VehicleHolidayPriceInfoBiz, VehicleHolidayPriceInfo> {

	@PostMapping(value = "/saveOrUpdate")
	public ObjectRestResponse saveOrUpdate(@RequestBody VehicleHolidayPriceInfo vehicleHolidayPriceInfo) {
		return baseBiz.addOrUpdate(vehicleHolidayPriceInfo);
	}

	@GetMapping(value = "getByVehicleId")
	public  ObjectRestResponse getByVehicleId(String vehicleId, String startDate, String endDate) {
		return ObjectRestResponse.succ(baseBiz.getByVehicleIdAndDate(vehicleId, startDate, endDate));
	}

	@GetMapping(value = "getAllByVehicleId")
	public  ObjectRestResponse getAllByVehicleId(String vehicleId) {
		return baseBiz.getByVehicleId(vehicleId);
	}

	@GetMapping(value = "getOne")
	public ObjectRestResponse getOne(Integer id) {
		return ObjectRestResponse.succ(baseBiz.selectById(id));
	}
}