package com.xxfc.platform.order.jobhandler;

import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.biz.DailyOrderStatisticsBiz;
import com.xxfc.platform.order.biz.DailyVehicleOrderStatisticsBiz;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 *  每天2定时统计前一天的数据
 * @author Administrator
 */
@JobHandler(value = "baseOrderStatisticsHandler")
@Component
@Slf4j
public class BaseOrderStatisticsJobHandler extends IJobHandler {
    @Autowired
    private DailyOrderStatisticsBiz statisticsBiz;

    @Override
    public ReturnT<String> execute(String s){
        try {

            XxlJobLogger.log("-----定时器进入---baseOrderStatisticsHandler---");
            log.info("-----定时器进入---baseOrderStatisticsHandler---");
            boolean flag = statisticsBiz.statisticalOrder();
            ReturnT returnT = new ReturnT();
            if (flag) {
                returnT.setCode(100);
                returnT.setMsg("成功");
                return returnT;
            }else {
                returnT.setCode(500);
                returnT.setMsg("失败");
                return returnT;
            }
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
        }
    }
}
