package com.xxfc.platform.im.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.im.biz.MsgBiz;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("msg")
public class MsgController {

    @Autowired
    private MsgBiz msgBiz;

    @PostMapping(value = "/app/unauth/list")
    public ObjectRestResponse getMsgList(Integer page, Integer limit, Integer type)throws Exception{
        return msgBiz.getMsgList(page, limit, type);
    }

    @PostMapping(value = "/app/unauth/hotMsg/list")
    public ObjectRestResponse getHotMsgList(Integer page, Integer limit) {
        return msgBiz.getHotMsgList(page, limit);
    }


    @GetMapping(value = "/get")
    public ObjectRestResponse get(String id) {
        return msgBiz.get(id);
    }

}
