package com.xxfc.platform.order;

import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.util.HashMap;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest(classes={OrderApplication.class})
public class RegionTest {



    @Test
    public void test() {
        //自动根据用户引入的模板引擎库的jar来自动选择使用的引擎
        //TemplateConfig为模板引擎的选项，可选内容有字符编码、模板路径、模板加载方式等，默认通过模板字符串渲染
        TemplateEngine engine = TemplateUtil.createEngine(new TemplateConfig());

        //假设我们引入的是Beetl引擎，则：
        //Template template = engine.getTemplate("{\"key\":\"费用明细\",\"val\":\"\",\"children\":[{\"key\":\"车辆租赁费\",\"val\":\"￥${vehicleAmount}\",\"children\":[{\"key\":\"${modelName}\",\"val\":\"￥${modelAmount}/天\"},{\"key\":\"租用天数\",\"val\":\"${dayNum}天\"},{\"key\":\"房车数量\",\"val\":\"${vehicleNum}辆\"}]},{\"key\":\"服务费（司机）\",\"val\":\"￥${driverAmount}\",\"children\":[{\"key\":\"欣新司机\",\"val\":\"￥${driverPrice}/天\"},{\"key\":\"司机数量\",\"val\":\"{driverNum}个\"},{\"key\":\"房车数量\",\"val\":\"${dayNum}天\"}]},{\"key\":\"用车押金\",\"val\":\"￥${deposit}\"}]}");
        Template template = engine.getTemplate("${[a,b,c]}");

        //Dict本质上为Map，此处可用Map
//        String result = template.render(Dict.create().set("name", "Hutool").set("name2", "Hutool2"));

        String result = "";

        result = template.render(new HashMap<String, Object>(){{
            put("a", 123);
            put("b", 456);
            put("c", 789);
        }});
                //template.render(
                //Dict.parse(new RentVehiclePriceVO(new BigDecimal("126800.03"), new BigDecimal("106800.03"), new BigDecimal("105000.03"), new BigDecimal("1800"), new BigDecimal("20000"))));

//        RentVehiclePriceVO.builder()
//                .orderAmount(new BigDecimal("126800.03"))
//                .goodsAmount(new BigDecimal("106800.03"))
//                .vehicleAmount(new BigDecimal("105000.03"))
//                .driverAmount(new BigDecimal("1800"))
//                .deposit(new BigDecimal("20000")).build()
        //输出：Hello Hutool
        log.info(result);
    }
}
